/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.snmp;

import ibm.nways.jdm.common.TimerService;
import ibm.nways.jdm.snmp.Def;
import ibm.nways.jdm.snmp.InitialConfig;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpStatistics;
import ibm.nways.jdm.snmp.SnmpTracer;
import ibm.nways.jdm.snmp.SystemDef;
import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpV1API {
    static final int default_trace_port = 7777;
    static InitialConfig initialConfiguration = null;
    public static boolean useEBCDIC;
    public static boolean exposeSecurityInfo;
    static final String apiVersion = "1.6";
    protected static boolean initialized;
    private static SnmpStatistics stats;
    protected static boolean tracing;
    protected static PrintStream traceFile;
    protected static DatagramSocket trapSocket;
    private static int trapSessions;

    protected SnmpV1API() {
    }

    public static synchronized void initialize(String string) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(string, 7777, true);
    }

    public static synchronized void initialize() throws SnmpSocketException, Exception {
        SnmpV1API.initialize("", 7777, true);
    }

    public static synchronized void initialize(int n) throws SnmpSocketException, Exception {
        SnmpV1API.initialize("", n, true);
    }

    public static synchronized void initialize(String string, int n) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(string, n, true);
    }

    public static synchronized void initialize(String string, int n, boolean bl) throws SnmpSocketException, Exception {
        if (initialized) {
            return;
        }
        if ("OS/390".equals(System.getProperty("os.name"))) {
            useEBCDIC = true;
        }
        try {
            stats = new SnmpStatistics();
            TimerService.initialize();
            if (n > 0) {
                SnmpTracer.initialize((int)n);
            }
            initialConfiguration = new InitialConfig(string);
            if (bl) {
                initialized = true;
                return;
            }
        }
        catch (SocketException socketException) {
            if (TimerService.isReady()) {
                TimerService.terminate();
                Thread.yield();
            }
            if (SnmpTracer.isReady()) {
                SnmpTracer.terminate();
                Thread.yield();
            }
            throw new SnmpSocketException(socketException.getMessage());
        }
    }

    public static synchronized void terminate() {
        Vector vector = SnmpSession.sessions;
        synchronized (vector) {
            initialized = false;
            Enumeration enumeration = SnmpSession.sessions.elements();
            while (enumeration.hasMoreElements()) {
                SnmpSession snmpSession = (SnmpSession)enumeration.nextElement();
                snmpSession.close();
            }
        }
        TimerService.terminate();
        Thread.yield();
        SnmpTracer.terminate();
        Thread.yield();
    }

    protected static void initializeTraps() throws SocketException {
        if (trapSocket == null) {
            try {
                trapSocket = new DatagramSocket();
            }
            catch (Exception exception) {
                throw new SnmpSocketException(exception.getMessage());
            }
        }
        ++trapSessions;
    }

    public static void terminateTraps() {
        if (--trapSessions <= 0 && trapSocket != null) {
            trapSocket.close();
            trapSocket = null;
        }
    }

    public static void addUserDef(Def def) {
        if (def.verify()) {
            System.out.println("SnmpAPI: addUserDef called - " + def.toString());
            System.out.flush();
            try {
                SnmpV1API.initialConfiguration.users.addEntry(def);
                return;
            }
            catch (Exception exception) {
                System.out.println("SnmpAPI: addUserDef failed - " + exception.toString());
                exception.printStackTrace();
                return;
            }
        }
        System.out.println("SnmpAPI: addUserDef called with invalid UserDef - " + def.toString());
    }

    public static void addSystemDef(SystemDef systemDef) {
        if (systemDef.verify()) {
            System.out.println("SnmpAPI: addSystemDef called - " + systemDef.toString());
            System.out.flush();
            try {
                SnmpV1API.initialConfiguration.systems.addEntry((Def)systemDef);
                return;
            }
            catch (Exception exception) {
                System.out.println("SnmpAPI: addUserDef failed - " + exception.toString());
                exception.printStackTrace();
                return;
            }
        }
        System.out.println("SnmpAPI: addSystemDef called with invalid SystemDef - " + systemDef.toString());
    }

    public static Def findHost(String string) {
        return SnmpV1API.initialConfiguration.systems.findEntry(string);
    }

    public static Def findUser(String string) {
        return SnmpV1API.initialConfiguration.users.findEntry(string);
    }

    public static SnmpStatistics getSnmpStats() {
        return stats;
    }

    public static synchronized void startTrace(PrintStream printStream) {
        tracing = true;
        traceFile = printStream;
        Date date = new Date();
        traceFile.println("*** Starting trace at " + date);
    }

    public static synchronized void stopTrace() {
        if (tracing) {
            Date date = new Date();
            traceFile.println("*** Stopping trace at " + date);
            tracing = false;
            traceFile = null;
        }
    }

    public static void setSecurityInfoPolicy(boolean bl) {
        exposeSecurityInfo = bl;
    }

    public static synchronized PrintStream getTraceFile() {
        return traceFile;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    static {
        exposeSecurityInfo = true;
        stats = null;
        traceFile = null;
        trapSocket = null;
    }
}

